#!/bin/bash
#NOTE: DO NOT EDIT THIS FILE-- MAY RESULT IN INCOMPLETE SUBMISSIONS
set -euo pipefail

CODE=(
    "panorama.py"
    "seam_carving.py"
    "sudoku.png"
    "utils.py"
    "uttower1.jpg"
    "uttower2.jpg"
    "yosemite1.jpg"
    "yosemite2.jpg"
    "yosemite3.jpg"
    "yosemite4.jpg"
    "solution_alternate_detected_corners.png"
    "solution_alternate_harris.png"
    "solution_detected_corners.png"
    "solution_fit_affine_panorama.png"
    "solution_harris.png"
    "solution_hog_panorama.png"
    "solution_hog_ransac.png"
    "solution_hog.png"
    "solution_linear_blend.png"
    "solution_ransac_panorama.png"
    "solution_ransac.png"
    "solution_simple_descriptor.png"
    "solution_stitched_images.png"
    "imgs/broadway_tower.jpg"
    "imgs/energy_soln.png"
    "imgs/enlarge_height_600.png"
    "imgs/enlarge_naive_width_800.png"
    "imgs/enlarge_width_800.png"
    "imgs/horizontal_cost_soln.png"
    "imgs/normal_vs_forward_cost.png"
    "imgs/optimal_vertical_seam_soln.png"
    "imgs/resize_height_300.png"
    "imgs/resize_width_400.png"
    "imgs/vertical_cost_soln.png"
    "imgs/wave.jpg"
    "imgs/wyeth_mask.jpg"
    "imgs/wyeth.jpg"
    "imgs/yolo.jpg"
)

# these notebooks should ideally
# be in order of questions so
# that the generated pdf is
# in order of questions
NOTEBOOKS=(
	"panorama.ipynb"
	"seam_carving.ipynb"

)

FILES=( "${CODE[@]}" "${NOTEBOOKS[@]}" )

LOCAL_DIR=`pwd`
ASSIGNMENT_NO=2
ZIP_FILENAME="a2_code_submission.zip"
PDF_FILENAME="a2_inline_submission.pdf"

C_R="\e[31m"
C_G="\e[32m"
C_BLD="\e[1m"
C_E="\e[0m"

for FILE in "${FILES[@]}"
do
	if [ ! -f ${FILE} ]; then
		echo -e "${C_R}Required file ${FILE} not found, Exiting.${C_E}"
		exit 0
	fi
done

echo -e "### Zipping file ###"
rm -f ${ZIP_FILENAME}
zip -q "${ZIP_FILENAME}" -r ${NOTEBOOKS[@]} $(find . -name "*.py") -x "makepdf.py"

echo -e "### Creating PDFs ###"
python makepdf.py --notebooks "${NOTEBOOKS[@]}" --pdf_filename "${PDF_FILENAME}"

echo -e "### Done! Please submit ${ZIP_FILENAME} and ${PDF_FILENAME} to Gradescope. ###"
